#include<uart.h>
#include<p30fxxxx.h>

/* UART2 is defined in following devices */
#if defined(__dsPIC30F3011__) || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F3013__) || defined(__dsPIC30F3014__) || defined(__dsPIC30F5011__)	|| \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__)

/*********************************************************************
* Function Name     : OpenUART2
* Description       : This function configures the UART mode,
*                     UART Interrupt modes and the Baud Rate
* Parameters        : unsigned int config1 operation setting
*                     unsigned int config2 TX & RX interrupt modes
*                     unsigned int ubrg baud rate setting
* Return Value      : None
*********************************************************************/

void OpenUART2(unsigned int config1,unsigned int config2, unsigned int ubrg)
{
    U2BRG  = ubrg;       /* baud rate */
    U2MODE = config1;    /* operation settings */
    U2STA = config2;     /* TX & RX interrupt modes */
}

#endif
